/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Request message for Reviews.BatchGetReviews.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchGetReviewsRequest extends com.google.api.client.json.GenericJson {

  /**
   * Whether to ignore rating-only reviews.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ignoreRatingOnlyReviews;

  /**
   * A collection of locations to fetch reviews for, specified by their names.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> locationNames;

  /**
   * Optional. Specifies the field to sort reviews by. If unspecified, the order of reviews returned
   * will default to `update_time desc`. Valid orders to sort by are `rating`, `rating desc` and
   * `update_time desc`. `rating` will return reviews in ascending order. `update_time`(i.e.
   * ascending order) is not supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String orderBy;

  /**
   * How many reviews to fetch per page. The default value is 200.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer pageSize;

  /**
   * If specified, it fetches the next page of reviews.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pageToken;

  /**
   * Whether to ignore rating-only reviews.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIgnoreRatingOnlyReviews() {
    return ignoreRatingOnlyReviews;
  }

  /**
   * Whether to ignore rating-only reviews.
   * @param ignoreRatingOnlyReviews ignoreRatingOnlyReviews or {@code null} for none
   */
  public BatchGetReviewsRequest setIgnoreRatingOnlyReviews(java.lang.Boolean ignoreRatingOnlyReviews) {
    this.ignoreRatingOnlyReviews = ignoreRatingOnlyReviews;
    return this;
  }

  /**
   * A collection of locations to fetch reviews for, specified by their names.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLocationNames() {
    return locationNames;
  }

  /**
   * A collection of locations to fetch reviews for, specified by their names.
   * @param locationNames locationNames or {@code null} for none
   */
  public BatchGetReviewsRequest setLocationNames(java.util.List<java.lang.String> locationNames) {
    this.locationNames = locationNames;
    return this;
  }

  /**
   * Optional. Specifies the field to sort reviews by. If unspecified, the order of reviews returned
   * will default to `update_time desc`. Valid orders to sort by are `rating`, `rating desc` and
   * `update_time desc`. `rating` will return reviews in ascending order. `update_time`(i.e.
   * ascending order) is not supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrderBy() {
    return orderBy;
  }

  /**
   * Optional. Specifies the field to sort reviews by. If unspecified, the order of reviews returned
   * will default to `update_time desc`. Valid orders to sort by are `rating`, `rating desc` and
   * `update_time desc`. `rating` will return reviews in ascending order. `update_time`(i.e.
   * ascending order) is not supported.
   * @param orderBy orderBy or {@code null} for none
   */
  public BatchGetReviewsRequest setOrderBy(java.lang.String orderBy) {
    this.orderBy = orderBy;
    return this;
  }

  /**
   * How many reviews to fetch per page. The default value is 200.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPageSize() {
    return pageSize;
  }

  /**
   * How many reviews to fetch per page. The default value is 200.
   * @param pageSize pageSize or {@code null} for none
   */
  public BatchGetReviewsRequest setPageSize(java.lang.Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  /**
   * If specified, it fetches the next page of reviews.
   * @return value or {@code null} for none
   */
  public java.lang.String getPageToken() {
    return pageToken;
  }

  /**
   * If specified, it fetches the next page of reviews.
   * @param pageToken pageToken or {@code null} for none
   */
  public BatchGetReviewsRequest setPageToken(java.lang.String pageToken) {
    this.pageToken = pageToken;
    return this;
  }

  @Override
  public BatchGetReviewsRequest set(String fieldName, Object value) {
    return (BatchGetReviewsRequest) super.set(fieldName, value);
  }

  @Override
  public BatchGetReviewsRequest clone() {
    return (BatchGetReviewsRequest) super.clone();
  }

}
