/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Response message for Verifications.ListVerifications.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListVerificationsResponse extends com.google.api.client.json.GenericJson {

  /**
   * If the number of verifications exceeded the requested page size, this field will be populated
   * with a token to fetch the next page of verification on a subsequent call. If there are no more
   * attributes, this field will not be present in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * List of the verifications.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Verification> verifications;

  static {
    // hack to force ProGuard to consider Verification used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Verification.class);
  }

  /**
   * If the number of verifications exceeded the requested page size, this field will be populated
   * with a token to fetch the next page of verification on a subsequent call. If there are no more
   * attributes, this field will not be present in the response.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If the number of verifications exceeded the requested page size, this field will be populated
   * with a token to fetch the next page of verification on a subsequent call. If there are no more
   * attributes, this field will not be present in the response.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListVerificationsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * List of the verifications.
   * @return value or {@code null} for none
   */
  public java.util.List<Verification> getVerifications() {
    return verifications;
  }

  /**
   * List of the verifications.
   * @param verifications verifications or {@code null} for none
   */
  public ListVerificationsResponse setVerifications(java.util.List<Verification> verifications) {
    this.verifications = verifications;
    return this;
  }

  @Override
  public ListVerificationsResponse set(String fieldName, Object value) {
    return (ListVerificationsResponse) super.set(fieldName, value);
  }

  @Override
  public ListVerificationsResponse clone() {
    return (ListVerificationsResponse) super.clone();
  }

}
