/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A radius around a particular point (latitude/longitude).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PointRadius extends com.google.api.client.json.GenericJson {

  /**
   * The latitude/longitude that specifies the center of an area defined by the radius.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LatLng latlng;

  /**
   * The distance in kilometers of the area around the point.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float radiusKm;

  /**
   * The latitude/longitude that specifies the center of an area defined by the radius.
   * @return value or {@code null} for none
   */
  public LatLng getLatlng() {
    return latlng;
  }

  /**
   * The latitude/longitude that specifies the center of an area defined by the radius.
   * @param latlng latlng or {@code null} for none
   */
  public PointRadius setLatlng(LatLng latlng) {
    this.latlng = latlng;
    return this;
  }

  /**
   * The distance in kilometers of the area around the point.
   * @return value or {@code null} for none
   */
  public java.lang.Float getRadiusKm() {
    return radiusKm;
  }

  /**
   * The distance in kilometers of the area around the point.
   * @param radiusKm radiusKm or {@code null} for none
   */
  public PointRadius setRadiusKm(java.lang.Float radiusKm) {
    this.radiusKm = radiusKm;
    return this;
  }

  @Override
  public PointRadius set(String fieldName, Object value) {
    return (PointRadius) super.set(fieldName, value);
  }

  @Override
  public PointRadius clone() {
    return (PointRadius) super.clone();
  }

}
