/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Response message for `Insights.ReportLocationInsights`.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportLocationInsightsResponse extends com.google.api.client.json.GenericJson {

  /**
   * A collection of values for driving direction-related metrics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LocationDrivingDirectionMetrics> locationDrivingDirectionMetrics;

  static {
    // hack to force ProGuard to consider LocationDrivingDirectionMetrics used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LocationDrivingDirectionMetrics.class);
  }

  /**
   * A collection of metric values by location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LocationMetrics> locationMetrics;

  static {
    // hack to force ProGuard to consider LocationMetrics used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LocationMetrics.class);
  }

  /**
   * A collection of values for driving direction-related metrics.
   * @return value or {@code null} for none
   */
  public java.util.List<LocationDrivingDirectionMetrics> getLocationDrivingDirectionMetrics() {
    return locationDrivingDirectionMetrics;
  }

  /**
   * A collection of values for driving direction-related metrics.
   * @param locationDrivingDirectionMetrics locationDrivingDirectionMetrics or {@code null} for none
   */
  public ReportLocationInsightsResponse setLocationDrivingDirectionMetrics(java.util.List<LocationDrivingDirectionMetrics> locationDrivingDirectionMetrics) {
    this.locationDrivingDirectionMetrics = locationDrivingDirectionMetrics;
    return this;
  }

  /**
   * A collection of metric values by location.
   * @return value or {@code null} for none
   */
  public java.util.List<LocationMetrics> getLocationMetrics() {
    return locationMetrics;
  }

  /**
   * A collection of metric values by location.
   * @param locationMetrics locationMetrics or {@code null} for none
   */
  public ReportLocationInsightsResponse setLocationMetrics(java.util.List<LocationMetrics> locationMetrics) {
    this.locationMetrics = locationMetrics;
    return this;
  }

  @Override
  public ReportLocationInsightsResponse set(String fieldName, Object value) {
    return (ReportLocationInsightsResponse) super.set(fieldName, value);
  }

  @Override
  public ReportLocationInsightsResponse clone() {
    return (ReportLocationInsightsResponse) super.clone();
  }

}
