/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A request for basic metric insights.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BasicMetricsRequest extends com.google.api.client.json.GenericJson {

  /**
   * A collection of metrics to return values for including the options for how the data should be
   * returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MetricRequest> metricRequests;

  static {
    // hack to force ProGuard to consider MetricRequest used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MetricRequest.class);
  }

  /**
   * The range to gather metrics for. The maximum range is 18 months from the request date. In some
   * cases, the data may still be missing for days close to the request date. Missing data will be
   * specified in the `metricValues` in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeRange timeRange;

  /**
   * A collection of metrics to return values for including the options for how the data should be
   * returned.
   * @return value or {@code null} for none
   */
  public java.util.List<MetricRequest> getMetricRequests() {
    return metricRequests;
  }

  /**
   * A collection of metrics to return values for including the options for how the data should be
   * returned.
   * @param metricRequests metricRequests or {@code null} for none
   */
  public BasicMetricsRequest setMetricRequests(java.util.List<MetricRequest> metricRequests) {
    this.metricRequests = metricRequests;
    return this;
  }

  /**
   * The range to gather metrics for. The maximum range is 18 months from the request date. In some
   * cases, the data may still be missing for days close to the request date. Missing data will be
   * specified in the `metricValues` in the response.
   * @return value or {@code null} for none
   */
  public TimeRange getTimeRange() {
    return timeRange;
  }

  /**
   * The range to gather metrics for. The maximum range is 18 months from the request date. In some
   * cases, the data may still be missing for days close to the request date. Missing data will be
   * specified in the `metricValues` in the response.
   * @param timeRange timeRange or {@code null} for none
   */
  public BasicMetricsRequest setTimeRange(TimeRange timeRange) {
    this.timeRange = timeRange;
    return this;
  }

  @Override
  public BasicMetricsRequest set(String fieldName, Object value) {
    return (BasicMetricsRequest) super.set(fieldName, value);
  }

  @Override
  public BasicMetricsRequest clone() {
    return (BasicMetricsRequest) super.clone();
  }

}
