/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A location. See the [help center article] (https://support.google.com/business/answer/3038177)
 * for a detailed description of these fields, or the [category endpoint](/my-
 * business/reference/rest/v4/categories) for a list of valid business categories.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Location extends com.google.api.client.json.GenericJson {

  /**
   * Additional information that is surfaced in AdWords.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AdWordsLocationExtensions adWordsLocationExtensions;

  /**
   * Additional categories to describe your business. Categories help your customers find accurate,
   * specific results for services they're interested in. To keep your business information accurate
   * and live, make sure that you use as few categories as possible to describe your overall core
   * business. Choose categories that are as specific as possible, but representative of your main
   * business.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Category> additionalCategories;

  static {
    // hack to force ProGuard to consider Category used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Category.class);
  }

  /**
   * Up to two phone numbers (mobile or landline, no fax) at which your business can be called, in
   * addition to your primary phone number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> additionalPhones;

  /**
   * A precise, accurate address to describe your business location. PO boxes or mailboxes located
   * at remote locations are not acceptable. At this time, you can specify a maximum of five
   * `address_lines` values in the address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PostalAddress address;

  /**
   * Attributes for this location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Attribute> attributes;

  /**
   * A collection of free-form strings to allow you to tag your business. These labels are NOT user
   * facing; only you can see them. Limited to 255 characters (per label).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> labels;

  /**
   * The language of the location. Set during creation and not updateable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * User-provided latitude and longitude. When creating a location, this field is ignored if the
   * provided address geocodes successfully. This field is only returned on get requests if the
   * user-provided `latlng` value was accepted during create, or the `latlng` value was updated
   * through the Google My Business website. This field cannot be updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LatLng latlng;

  /**
   * A collection of keys that link this business to other Google properties, such as a Google+ page
   * and Google Maps Places.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocationKey locationKey;

  /**
   * Location name should reflect your business's real-world name, as used consistently on your
   * storefront, website, and stationery, and as known to customers. Any additional information,
   * when relevant, can be included in other fields of the resource (for example, `Address`,
   * `Categories`). Don't add unnecessary information to your name (for example, prefer "Google"
   * over "Google Inc. - Mountain View Corporate Headquarters"). Don't include marketing taglines,
   * store codes, special characters, hours or closed/open status, phone numbers, website URLs,
   * service/product information, location/address or directions, or containment information (for
   * example, "Chase ATM in Duane Reade").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationName;

  /**
   * Output only. A set of booleans that reflects the [state of a
   * location.](https://support.google.com/business/answer/3480862)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocationState locationState;

  /**
   * Output Only. Additional non-user-editable information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Metadata metadata;

  /**
   * More hours for a business's different departments or specific customers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MoreHours> moreHours;

  /**
   * Google identifier for this location in the form:
   * `accounts/{account_id}/locations/{location_id}` In the context of matches, this field will not
   * be populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A flag that indicates whether the location is currently open for business.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OpenInfo openInfo;

  /**
   * Price list information for this location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PriceList> priceLists;

  static {
    // hack to force ProGuard to consider PriceList used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PriceList.class);
  }

  /**
   * Category that best describes the core business this location engages in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Category primaryCategory;

  /**
   * A phone number that connects to your individual business location as directly as possible. Use
   * a local phone number instead of a central, call center helpline number whenever possible.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String primaryPhone;

  /**
   * Describes your business in your own voice and shares with users the unique story of your
   * business and offerings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Profile profile;

  /**
   * Operating hours for the business.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BusinessHours regularHours;

  /**
   * All locations and chain related to this one.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RelationshipData relationshipData;

  /**
   * Service area businesses provide their service at the customer's location. If this business is a
   * service area business, this field describes the area(s) serviced by the business.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ServiceAreaBusiness serviceArea;

  /**
   * Special hours for the business. This typically includes holiday hours, and other times outside
   * of regular operating hours. These override regular business hours.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SpecialHours specialHours;

  /**
   * External identifier for this location, which must be unique inside a given account. This is a
   * means of associating the location with your own records.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String storeCode;

  /**
   * A URL for this business. If possible, use a URL that represents this individual business
   * location instead of a generic website/URL that represents all locations, or the brand.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String websiteUrl;

  /**
   * Additional information that is surfaced in AdWords.
   * @return value or {@code null} for none
   */
  public AdWordsLocationExtensions getAdWordsLocationExtensions() {
    return adWordsLocationExtensions;
  }

  /**
   * Additional information that is surfaced in AdWords.
   * @param adWordsLocationExtensions adWordsLocationExtensions or {@code null} for none
   */
  public Location setAdWordsLocationExtensions(AdWordsLocationExtensions adWordsLocationExtensions) {
    this.adWordsLocationExtensions = adWordsLocationExtensions;
    return this;
  }

  /**
   * Additional categories to describe your business. Categories help your customers find accurate,
   * specific results for services they're interested in. To keep your business information accurate
   * and live, make sure that you use as few categories as possible to describe your overall core
   * business. Choose categories that are as specific as possible, but representative of your main
   * business.
   * @return value or {@code null} for none
   */
  public java.util.List<Category> getAdditionalCategories() {
    return additionalCategories;
  }

  /**
   * Additional categories to describe your business. Categories help your customers find accurate,
   * specific results for services they're interested in. To keep your business information accurate
   * and live, make sure that you use as few categories as possible to describe your overall core
   * business. Choose categories that are as specific as possible, but representative of your main
   * business.
   * @param additionalCategories additionalCategories or {@code null} for none
   */
  public Location setAdditionalCategories(java.util.List<Category> additionalCategories) {
    this.additionalCategories = additionalCategories;
    return this;
  }

  /**
   * Up to two phone numbers (mobile or landline, no fax) at which your business can be called, in
   * addition to your primary phone number.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAdditionalPhones() {
    return additionalPhones;
  }

  /**
   * Up to two phone numbers (mobile or landline, no fax) at which your business can be called, in
   * addition to your primary phone number.
   * @param additionalPhones additionalPhones or {@code null} for none
   */
  public Location setAdditionalPhones(java.util.List<java.lang.String> additionalPhones) {
    this.additionalPhones = additionalPhones;
    return this;
  }

  /**
   * A precise, accurate address to describe your business location. PO boxes or mailboxes located
   * at remote locations are not acceptable. At this time, you can specify a maximum of five
   * `address_lines` values in the address.
   * @return value or {@code null} for none
   */
  public PostalAddress getAddress() {
    return address;
  }

  /**
   * A precise, accurate address to describe your business location. PO boxes or mailboxes located
   * at remote locations are not acceptable. At this time, you can specify a maximum of five
   * `address_lines` values in the address.
   * @param address address or {@code null} for none
   */
  public Location setAddress(PostalAddress address) {
    this.address = address;
    return this;
  }

  /**
   * Attributes for this location.
   * @return value or {@code null} for none
   */
  public java.util.List<Attribute> getAttributes() {
    return attributes;
  }

  /**
   * Attributes for this location.
   * @param attributes attributes or {@code null} for none
   */
  public Location setAttributes(java.util.List<Attribute> attributes) {
    this.attributes = attributes;
    return this;
  }

  /**
   * A collection of free-form strings to allow you to tag your business. These labels are NOT user
   * facing; only you can see them. Limited to 255 characters (per label).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLabels() {
    return labels;
  }

  /**
   * A collection of free-form strings to allow you to tag your business. These labels are NOT user
   * facing; only you can see them. Limited to 255 characters (per label).
   * @param labels labels or {@code null} for none
   */
  public Location setLabels(java.util.List<java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The language of the location. Set during creation and not updateable.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * The language of the location. Set during creation and not updateable.
   * @param languageCode languageCode or {@code null} for none
   */
  public Location setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * User-provided latitude and longitude. When creating a location, this field is ignored if the
   * provided address geocodes successfully. This field is only returned on get requests if the
   * user-provided `latlng` value was accepted during create, or the `latlng` value was updated
   * through the Google My Business website. This field cannot be updated.
   * @return value or {@code null} for none
   */
  public LatLng getLatlng() {
    return latlng;
  }

  /**
   * User-provided latitude and longitude. When creating a location, this field is ignored if the
   * provided address geocodes successfully. This field is only returned on get requests if the
   * user-provided `latlng` value was accepted during create, or the `latlng` value was updated
   * through the Google My Business website. This field cannot be updated.
   * @param latlng latlng or {@code null} for none
   */
  public Location setLatlng(LatLng latlng) {
    this.latlng = latlng;
    return this;
  }

  /**
   * A collection of keys that link this business to other Google properties, such as a Google+ page
   * and Google Maps Places.
   * @return value or {@code null} for none
   */
  public LocationKey getLocationKey() {
    return locationKey;
  }

  /**
   * A collection of keys that link this business to other Google properties, such as a Google+ page
   * and Google Maps Places.
   * @param locationKey locationKey or {@code null} for none
   */
  public Location setLocationKey(LocationKey locationKey) {
    this.locationKey = locationKey;
    return this;
  }

  /**
   * Location name should reflect your business's real-world name, as used consistently on your
   * storefront, website, and stationery, and as known to customers. Any additional information,
   * when relevant, can be included in other fields of the resource (for example, `Address`,
   * `Categories`). Don't add unnecessary information to your name (for example, prefer "Google"
   * over "Google Inc. - Mountain View Corporate Headquarters"). Don't include marketing taglines,
   * store codes, special characters, hours or closed/open status, phone numbers, website URLs,
   * service/product information, location/address or directions, or containment information (for
   * example, "Chase ATM in Duane Reade").
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationName() {
    return locationName;
  }

  /**
   * Location name should reflect your business's real-world name, as used consistently on your
   * storefront, website, and stationery, and as known to customers. Any additional information,
   * when relevant, can be included in other fields of the resource (for example, `Address`,
   * `Categories`). Don't add unnecessary information to your name (for example, prefer "Google"
   * over "Google Inc. - Mountain View Corporate Headquarters"). Don't include marketing taglines,
   * store codes, special characters, hours or closed/open status, phone numbers, website URLs,
   * service/product information, location/address or directions, or containment information (for
   * example, "Chase ATM in Duane Reade").
   * @param locationName locationName or {@code null} for none
   */
  public Location setLocationName(java.lang.String locationName) {
    this.locationName = locationName;
    return this;
  }

  /**
   * Output only. A set of booleans that reflects the [state of a
   * location.](https://support.google.com/business/answer/3480862)
   * @return value or {@code null} for none
   */
  public LocationState getLocationState() {
    return locationState;
  }

  /**
   * Output only. A set of booleans that reflects the [state of a
   * location.](https://support.google.com/business/answer/3480862)
   * @param locationState locationState or {@code null} for none
   */
  public Location setLocationState(LocationState locationState) {
    this.locationState = locationState;
    return this;
  }

  /**
   * Output Only. Additional non-user-editable information.
   * @return value or {@code null} for none
   */
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * Output Only. Additional non-user-editable information.
   * @param metadata metadata or {@code null} for none
   */
  public Location setMetadata(Metadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * More hours for a business's different departments or specific customers.
   * @return value or {@code null} for none
   */
  public java.util.List<MoreHours> getMoreHours() {
    return moreHours;
  }

  /**
   * More hours for a business's different departments or specific customers.
   * @param moreHours moreHours or {@code null} for none
   */
  public Location setMoreHours(java.util.List<MoreHours> moreHours) {
    this.moreHours = moreHours;
    return this;
  }

  /**
   * Google identifier for this location in the form:
   * `accounts/{account_id}/locations/{location_id}` In the context of matches, this field will not
   * be populated.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Google identifier for this location in the form:
   * `accounts/{account_id}/locations/{location_id}` In the context of matches, this field will not
   * be populated.
   * @param name name or {@code null} for none
   */
  public Location setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * A flag that indicates whether the location is currently open for business.
   * @return value or {@code null} for none
   */
  public OpenInfo getOpenInfo() {
    return openInfo;
  }

  /**
   * A flag that indicates whether the location is currently open for business.
   * @param openInfo openInfo or {@code null} for none
   */
  public Location setOpenInfo(OpenInfo openInfo) {
    this.openInfo = openInfo;
    return this;
  }

  /**
   * Price list information for this location.
   * @return value or {@code null} for none
   */
  public java.util.List<PriceList> getPriceLists() {
    return priceLists;
  }

  /**
   * Price list information for this location.
   * @param priceLists priceLists or {@code null} for none
   */
  public Location setPriceLists(java.util.List<PriceList> priceLists) {
    this.priceLists = priceLists;
    return this;
  }

  /**
   * Category that best describes the core business this location engages in.
   * @return value or {@code null} for none
   */
  public Category getPrimaryCategory() {
    return primaryCategory;
  }

  /**
   * Category that best describes the core business this location engages in.
   * @param primaryCategory primaryCategory or {@code null} for none
   */
  public Location setPrimaryCategory(Category primaryCategory) {
    this.primaryCategory = primaryCategory;
    return this;
  }

  /**
   * A phone number that connects to your individual business location as directly as possible. Use
   * a local phone number instead of a central, call center helpline number whenever possible.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrimaryPhone() {
    return primaryPhone;
  }

  /**
   * A phone number that connects to your individual business location as directly as possible. Use
   * a local phone number instead of a central, call center helpline number whenever possible.
   * @param primaryPhone primaryPhone or {@code null} for none
   */
  public Location setPrimaryPhone(java.lang.String primaryPhone) {
    this.primaryPhone = primaryPhone;
    return this;
  }

  /**
   * Describes your business in your own voice and shares with users the unique story of your
   * business and offerings.
   * @return value or {@code null} for none
   */
  public Profile getProfile() {
    return profile;
  }

  /**
   * Describes your business in your own voice and shares with users the unique story of your
   * business and offerings.
   * @param profile profile or {@code null} for none
   */
  public Location setProfile(Profile profile) {
    this.profile = profile;
    return this;
  }

  /**
   * Operating hours for the business.
   * @return value or {@code null} for none
   */
  public BusinessHours getRegularHours() {
    return regularHours;
  }

  /**
   * Operating hours for the business.
   * @param regularHours regularHours or {@code null} for none
   */
  public Location setRegularHours(BusinessHours regularHours) {
    this.regularHours = regularHours;
    return this;
  }

  /**
   * All locations and chain related to this one.
   * @return value or {@code null} for none
   */
  public RelationshipData getRelationshipData() {
    return relationshipData;
  }

  /**
   * All locations and chain related to this one.
   * @param relationshipData relationshipData or {@code null} for none
   */
  public Location setRelationshipData(RelationshipData relationshipData) {
    this.relationshipData = relationshipData;
    return this;
  }

  /**
   * Service area businesses provide their service at the customer's location. If this business is a
   * service area business, this field describes the area(s) serviced by the business.
   * @return value or {@code null} for none
   */
  public ServiceAreaBusiness getServiceArea() {
    return serviceArea;
  }

  /**
   * Service area businesses provide their service at the customer's location. If this business is a
   * service area business, this field describes the area(s) serviced by the business.
   * @param serviceArea serviceArea or {@code null} for none
   */
  public Location setServiceArea(ServiceAreaBusiness serviceArea) {
    this.serviceArea = serviceArea;
    return this;
  }

  /**
   * Special hours for the business. This typically includes holiday hours, and other times outside
   * of regular operating hours. These override regular business hours.
   * @return value or {@code null} for none
   */
  public SpecialHours getSpecialHours() {
    return specialHours;
  }

  /**
   * Special hours for the business. This typically includes holiday hours, and other times outside
   * of regular operating hours. These override regular business hours.
   * @param specialHours specialHours or {@code null} for none
   */
  public Location setSpecialHours(SpecialHours specialHours) {
    this.specialHours = specialHours;
    return this;
  }

  /**
   * External identifier for this location, which must be unique inside a given account. This is a
   * means of associating the location with your own records.
   * @return value or {@code null} for none
   */
  public java.lang.String getStoreCode() {
    return storeCode;
  }

  /**
   * External identifier for this location, which must be unique inside a given account. This is a
   * means of associating the location with your own records.
   * @param storeCode storeCode or {@code null} for none
   */
  public Location setStoreCode(java.lang.String storeCode) {
    this.storeCode = storeCode;
    return this;
  }

  /**
   * A URL for this business. If possible, use a URL that represents this individual business
   * location instead of a generic website/URL that represents all locations, or the brand.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebsiteUrl() {
    return websiteUrl;
  }

  /**
   * A URL for this business. If possible, use a URL that represents this individual business
   * location instead of a generic website/URL that represents all locations, or the brand.
   * @param websiteUrl websiteUrl or {@code null} for none
   */
  public Location setWebsiteUrl(java.lang.String websiteUrl) {
    this.websiteUrl = websiteUrl;
    return this;
  }

  @Override
  public Location set(String fieldName, Object value) {
    return (Location) super.set(fieldName, value);
  }

  @Override
  public Location clone() {
    return (Location) super.clone();
  }

}
