// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.pay.echo.inbound.domain;

/**
 * Defines the echo request header in the echo request for the "/v2/echo" api.
 *
 * @see <a href=
 *     "https://developers.google.com/standard-payments/payment-integrator-diagnostic-api/v2/TopLevel/echo#requestheader">
 *     Request Header </a>
 */
public class InboundRequestHeader {

  private InboundProtocolVersion protocolVersion;
  private String requestId;
  private Timestamp requestTimestamp;
  private String paymentIntegratorAccountId;

  public InboundProtocolVersion getProtocolVersion() {
    return protocolVersion;
  }

  public void setProtocolVersion(InboundProtocolVersion protocolVersion) {
    this.protocolVersion = protocolVersion;
  }

  public String getRequestId() {
    return requestId;
  }

  public void setRequestId(String requestId) {
    this.requestId = requestId;
  }

  public Timestamp getRequestTimestamp() {
    return requestTimestamp;
  }

  public void setRequestTimestamp(Timestamp requestTimestamp) {
    this.requestTimestamp = requestTimestamp;
  }

  public String getPaymentIntegratorAccountId() {
    return paymentIntegratorAccountId;
  }

  public void setPaymentIntegratorAccountId(String paymentIntegratorAccountId) {
    this.paymentIntegratorAccountId = paymentIntegratorAccountId;
  }
}
