/**
 * Copyright 2021 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Middleware function that checks to see if there is a signed-in
 * user sessions before continuing to the route. If there is not, then the user
 * is redirected to sign-in.
 */

const checkAuthenticated = (req, res, next) => {
  // Check to see if we have a user in this session.
  const isLoggedIn = !!req.session.user && !!req.session.tokens;

  if (isLoggedIn) { return next() }
  res.redirect("/signin");
};

module.exports = checkAuthenticated;
