/**
 * Copyright 2021 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview This module serves routes that begin with "/classroom-addon".
 * These routes are Classroom add-on specific.
 */

var express = require('express');
var router = express.Router();
var getAddonQS = require('../middleware/getaddonqs');
var checkAuthenticated = require('../middleware/checkAuthenticated');

/**
 * Route: /classroom-addon
 *
 * This route renders the add-on homepage.
 */
router.get('/', [getAddonQS, checkAuthenticated], function (req, res, next) {
  res.render('discovery', {
    layout: 'addon.hbs',
    title: 'Education Technology Classroom add-on',
    message: `Welcome ${req.session.user.displayName}.`
  });
});

/**
 * Route: /classroom-addon/page2
 *
 * This route renders a second page meant to illustrate navigating between
 * pages within the add-on iframe.
 */
router.get('/page2', checkAuthenticated, function (req, res, next) {
  res.render('discovery', {
    layout: 'addon.hbs',
    title: 'Page 2',
    message: `Welcome ${req.session.user.displayName}.`
  });
});

module.exports = router;
