/**
 * Copyright 2021 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Middleware function to capture Classroom add-on query params
 * and store them into the session so that each route will have access to this
 * information. This is important should the user get redirected to a sign-in
 * flow and then back to the add-on on successful sign-in.
 */

const getAddonQS = (req, res, next) => {
  if (req.session.addon == undefined) {
    req.session.addon = {};
  }

  // If this is the first load of an iframe there will be querystring
  // params passed by Classroom. Store these params in the current session
  // so that we have them upon completion of sign-in.
  if (req.query.courseId) {
    // If courseId was present, then we'll replace everything we have
    // with a new set of data as a user may have loaded a new iframe within
    // the same session.
    req.session.addon = { ...req.query };

    console.log('addon params:', req.session.addon);
  }
  next();
};

module.exports = getAddonQS;
